import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
/*code 
  by
  @siddhanth.reddy */
public class Calculator implements ActionListener{

	JFrame frame;
	JTextField tf;
	JButton[] num = new JButton[10];
	JButton[] func = new JButton[9];
	JButton addition,subtraction,multiplication,division;
	JButton decButton, equButton, delButton, clrButton, negButton;
	JPanel panel;
	
	Font myF = new Font("Times New Roman",Font.BOLD,30);
	
	double num1=0,num2=0,result=0;
	char op;
	
	Calculator(){
		
		frame = new JFrame("My-Calculator");
		frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		frame.getContentPane().setBackground(Color.MAGENTA);
		frame.setSize(500,600);
		frame.setLayout(null);
		tf = new JTextField();
		tf.setBackground(Color.YELLOW);
		tf.setBounds(60, 25, 350, 60);
		tf.setFont(myF);
		tf.setEditable(false);
		
		addition = new JButton("+");
		subtraction = new JButton("-");
		multiplication = new JButton("*");
		division = new JButton("/");
		decButton = new JButton(".");
		equButton = new JButton("=");
		delButton = new JButton("Del");
		clrButton = new JButton("Clr");
		negButton = new JButton("Neg");
		
		
		addition.setBackground(Color.GRAY);
        addition.setOpaque(true);
        subtraction.setBackground(Color.GRAY);
        subtraction.setOpaque(true);
        multiplication.setBackground(Color.GRAY);
        multiplication.setOpaque(true);
        division.setBackground(Color.GRAY);
        division.setOpaque(true);
        negButton.setBackground(Color.GRAY);
        negButton.setOpaque(true);
        equButton.setBackground(Color.GRAY);
        equButton.setOpaque(true);
        delButton.setBackground(Color.GRAY);
        delButton.setOpaque(true);
        clrButton.setBackground(Color.GRAY);
        clrButton.setOpaque(true);

		func[0] = addition;
		func[1] = subtraction;
		func[2] = multiplication;
		func[3] = division;
		func[4] = decButton;
		func[5] = equButton;
		func[6] = delButton;
		func[7] = clrButton;
		func[8] = negButton;
		
		for(int i =0;i<9;i++) {
			func[i].addActionListener(this);
			func[i].setFont(myF);
			func[i].setFocusable(false);
		}
		
		for(int i =0;i<10;i++) {
			num[i] = new JButton(String.valueOf(i));
			num[i].addActionListener(this);
			num[i].setFont(myF);
			num[i].setFocusable(false);
		}
		
		negButton.setBounds(50,430,100,50);
		delButton.setBounds(150,430,100,50);
		clrButton.setBounds(250,430,100,50);
		
		panel = new JPanel();
		panel.setBounds(50, 100, 300, 300);
		panel.setLayout(new GridLayout(4,4,10,10));

		panel.add(num[1]);
		panel.add(num[2]);
		panel.add(num[3]);
		panel.add(addition);
		panel.add(num[4]);
		panel.add(num[5]);
		panel.add(num[6]);
		panel.add(subtraction);
		panel.add(num[7]);
		panel.add(num[8]);
		panel.add(num[9]);
		panel.add(multiplication);
		panel.add(decButton);
		panel.add(num[0]);
		panel.add(equButton);
		panel.add(division);
		
		frame.add(panel);
		frame.add(negButton);
		frame.add(delButton);
		frame.add(clrButton);
		frame.add(tf);
		frame.setVisible(true);
	}
	
	public static void main(String[] args) {
		
		Calculator calc = new Calculator();
	}
	
	@Override
	public void actionPerformed(ActionEvent ev) {
		
		for(int i=0;i<10;i++) {
			if(ev.getSource() == num[i]) {
				tf.setText(tf.getText().concat(String.valueOf(i)));
			}
		}
		if(ev.getSource()==decButton) {
			tf.setText(tf.getText().concat("."));
		}
		if(ev.getSource()==addition) {
			num1 = Double.parseDouble(tf.getText());
			op ='+';
			tf.setText("");
		}
		if(ev.getSource()==subtraction) {
			num1 = Double.parseDouble(tf.getText());
			op ='-';
			tf.setText("");
		}
		if(ev.getSource()==multiplication) {
			num1 = Double.parseDouble(tf.getText());
			op ='*';
			tf.setText("");
		}
		if(ev.getSource()==division) {
			num1 = Double.parseDouble(tf.getText());
			op ='/';
			tf.setText("");
		}
		if(ev.getSource()==equButton) {
			num2=Double.parseDouble(tf.getText());
			
			switch(op) {
			case'+':
				result=num1+num2;
				break;
			case'-':
				result=num1-num2;
				break;
			case'*':
				result=num1*num2;
				break;
			case'/':
				result=num1/num2;
				break;
			}
			tf.setText(String.valueOf(result));
			num1=result;
		}
		if(ev.getSource()==clrButton) {
			tf.setText("");
		}
		if(ev.getSource()==delButton) {
			String string = tf.getText();
			tf.setText("");
			for(int i=0;i<string.length()-1;i++) {
				tf.setText(tf.getText()+string.charAt(i));
			}
		}
		if(ev.getSource()==negButton) {
			double temp = Double.parseDouble(tf.getText());
			temp*=-1;
			tf.setText(String.valueOf(temp));
		}
	}
}